<?php
include 'conexao.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $nome = $_POST['nome'];
    $turma = $_POST['turma'];
    $classe = $_POST['classe'];
    $sala = $_POST['sala'];
    $nome_pai = $_POST['nome_pai'];
    $nome_mae = $_POST['nome_mae'];
    $data_nascimento = $_POST['data_nascimento'];
    $naturalidade = $_POST['naturalidade'];
    $bi_numero = $_POST['bi_numero'];
    $bi_emitido_em = $_POST['bi_emitido_em'];
    $bi_data_emissao = $_POST['bi_data_emissao'];
    $curso = $_POST['curso'];
    $idade = $_POST['idade'];
    $ano_letivo = $_POST['ano_letivo'];
    $genero = $_POST['genero'];

    // Buscar a foto atual do aluno
    $resFoto = $conn->query("SELECT foto FROM alunos WHERE id = $id");
    $fotoAtual = '';
    if ($resFoto && $resFoto->num_rows > 0) {
        $row = $resFoto->fetch_assoc();
        $fotoAtual = $row['foto'];
    }

    // Upload da nova foto (se enviada)
    $novaFoto = $fotoAtual;
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION);
        $nomeUnico = uniqid('foto_') . "." . strtolower($ext);
        $destino = "fotos/" . $nomeUnico;

        if (move_uploaded_file($_FILES['foto']['tmp_name'], $destino)) {
            $novaFoto = $nomeUnico;

            // Opcional: deletar a foto antiga se existir e for diferente de 'sem_foto.png'
            if (!empty($fotoAtual) && file_exists("fotos/" . $fotoAtual) && $fotoAtual !== 'sem_foto.png') {
                unlink("fotos/" . $fotoAtual);
            }
        }
    }

    // Atualizar dados no banco
    $stmt = $conn->prepare("
        UPDATE alunos SET 
            nome = ?, turma = ?, classe = ?, sala = ?, nome_pai = ?, nome_mae = ?, 
            data_nascimento = ?, naturalidade = ?, bi_numero = ?, bi_emitido_em = ?, 
            bi_data_emissao = ?, curso = ?, idade = ?, ano_letivo = ?, genero = ?, foto = ?
        WHERE id = ?
    ");
    $stmt->bind_param(
        "ssssssssssssssssi",
        $nome, $turma, $classe, $sala, $nome_pai, $nome_mae,
        $data_nascimento, $naturalidade, $bi_numero, $bi_emitido_em,
        $bi_data_emissao, $curso, $idade, $ano_letivo, $genero, $novaFoto,
        $id
    );

    if ($stmt->execute()) {
        echo "<script>alert('Dados atualizados com sucesso!'); window.location='cadastrar_aluno.php';</script>";
    } else {
        echo "Erro ao atualizar: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
